<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
  <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
  <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
  <xsl:template match="/">
    <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))" />
    <html>
      <head>
        <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
        <title lang="en">Výpis Staničení Odstup XYZ Prvek</title>
      </head>
      <body>
        <xsl:choose>
          <xsl:when test="$xslShowHelp = 'true'">
            <xsl:call-template name="StyleSheetHelp"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="InRoads">
              <center>
                <h2 lang="en">Výpis Staničení Odstup XYZ Prvek</h2>
                <p lang="en">
                  Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                  Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                </p>
              </center>

              <xsl:for-each select="GeometryProject">
                <table class="margin" cellpadding="2" width="90%">
                  <tbody>
                    <tr>
                      <th align="right" lang="en">Projekt:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@name"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">Popis:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@description"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">Základní trasa:</th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="HorizontalAlignment/@name"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">Název souboru:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="@file"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en">Poslední úprava:&#xa0; </th>
                      <td align="left" colspan="2">
                        <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                      </td>
                    </tr>
                    <tr>
                      <th align="right" lang="en" style="font-size: 80%">Koeficient Vstupní rastr:&#xa0; </th>
                      <td align="left" style="font-size: 80%">
                        <xsl:value-of select="../@inputGridScaleFactor" />
                      </td>
                      <td align="right" lang="en" style="font-size: 80%">
                        <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                        <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                        <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                        pokud není specifikováno jinak.
                      </td>
                    </tr>
                  </tbody>
                </table>
                <hr/>

                <!-- From Custom Point Station Offset Elevation Feature command -->
                <xsl:for-each select="HorizontalAlignment[OffsetPoint]">
                  <table cellspacing="4" width="100%">
                    <thead style="display:table-header-group">
                      <tr>
                        <th class="underline" lang="en" align="left">Bod</th>
                        <th class="underline" lang="en" align="left">Staničení</th>
                        <th class="underline" lang="en" align="left">Odstup</th>
                        <th class="underline" lang="en" align="left">Y</th>
                        <th class="underline" lang="en" align="left">X</th>
                        <th class="underline" lang="en" align="left">Z</th>
                        <th class="underline" lang="en" align="left">Prvek</th>
                      </tr>
                    </thead>
                    <tbody>
                        <xsl:for-each select="OffsetPoint/GeometryPointProperties">
                          <tr>
                            <td align="left">
                              <xsl:value-of select="@PointName"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="cif:stationFormat(number(station/@externalStation),string(station/@externalStationName))"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="cif:distanceFormat(number(@offset))"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="cif:ordinateFormat(number(@northing))"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="cif:ordinateFormat(number(@easting))"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="cif:ordinateFormat(number(@elevation))"/>
                            </td>
                            <td align="left">
                              <xsl:value-of select="@FeatureName"/>
                            </td>
                          </tr>
                      </xsl:for-each>
                    </tbody>
                  </table>
                </xsl:for-each>

                <!--From Alignment Station Offset command -->
                <xsl:for-each select="HorizontalAlignment[StationOffsetPoints]">
                  <table cellspacing="4" width="100%">

                    <tbody>
                      <xsl:for-each select="StationOffsetPoints/StationOffsetPoint">
                        <tr>
                          <xsl:if test="not(@offsetAlignmentName = preceding-sibling::*/@offsetAlignmentName)">
                            <tr>
                              <th class="underline" lang="en" align="left">
                                Základní trasa
                                <br>
                                  (<xsl:value-of select="../../../HorizontalAlignment/@name"/>)
                                </br>
                                <br />
                                Bod Typ
                              </th>
                              <th class="underline" lang="en" align="left">
                                Odstup Trasa
                                <br>
                                  (<xsl:value-of select="@offsetAlignmentName"/>)
                                </br>
                                <br />
                                Bod Název
                              </th>
                              <th class="underline" lang="en" align="left">
                                <br />
                                Základní trasa<br />Staničení
                              </th>
                              <th class="underline" lang="en" align="left">
                                <br />
                                Základní trasa<br />Odstup
                              </th>
                              <th class="underline" lang="en" align="left">
                                <br />
                                Odstup Trasa<br />Y
                              </th>
                              <th class="underline" lang="en" align="left">
                                <br />
                                Odstup Trasa<br />X
                              </th>
                              <th class="underline" lang="en" align="left">
                                <br />
                                Odstup Trasa<br />Z
                              </th>
                              <th class="underline" lang="en" align="left">
                                <br />
                                Odstup Trasa<br />Prvek
                              </th>
                            </tr>
                          </xsl:if>
                          <td align="left">
                            <xsl:value-of select="centerLinePoint/point/@type"/>
                          </td>
                          <td align="left">
                            <xsl:value-of select="offsetPoint/@name"/>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:stationFormat(number(centerLinePoint/point/station/@externalStation),string(centerLinePoint/point/station/@externalStationName))"/>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:distanceFormat(number(@firstOffset))"/>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:ordinateFormat(number(offsetPoint/@northing))"/>
                          </td>
                          <td align="left">
                            <xsl:value-of select="cif:ordinateFormat(number(offsetPoint/@easting))"/>
                          </td>
                          <td align="left">
                            <xsl:if test="offsetPoint/@elevation">
                              <xsl:value-of select="cif:ordinateFormat(number(offsetPoint/@elevation))"/>
                            </xsl:if>
                          </td>
                          <td align="left">
                            <xsl:value-of select="@FeatureName"/>
                          </td>
                        </tr>
                      </xsl:for-each>
                    </tbody>
                  </table>
                </xsl:for-each>

              </xsl:for-each>

            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </body>
    </html>
  </xsl:template>

  <xsl:template name="StyleSheetHelp">
    <div class="section1">
      <h4 lang="en">Poznámky</h4>
      <p class="normal1" lang="en">
         Pro tento výpis musíte vytvořit body ve staničení a odstupu pomocí 
                <em> Nástroje &gt; XML Výpisy &gt; Staničení Odstup
									 
        </em>.
      </p>
      <p class="normal1" lang="en">
         Musíte vybrat nejméně jedno směrové řešení nebo jeden prvek v listu <em>Obecně</em>, v poli <em>Z</em>.
										 
      </p>
      <p class="normal1" lang="en">
        Musíte také vybrat nejméně jedno směrové řešení v listu <em>Směrová řešení</em> nebo prvek v listu <em>Prvky</em>.
							   
																 
      </p>
      <p class="normal1" lang="en">
        Musíte vybrat nejméně jednu volbu v listu <em>Zahrnout</em> 
		 (<em>Směrové body - Na trase, Významné, 
		Výškové body - Na trase, Významné
        </em> nebo <em>Interval</em>.)
      </p>
      <p class="small" lang="en">
        <em>&#xa9; 2013 Bentley Systems, Inc</em>
      </p>
    </div>
  </xsl:template>
</xsl:stylesheet>